/*
 * Decompiled with CFR 0.152.
 */
package com.mysticsbiomes.init;

import com.mysticsbiomes.common.block.StrawberryBushBlock;
import com.mysticsbiomes.init.MysticBlocks;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BushFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.RandomSpreadFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.BendingTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.FancyTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.NoiseBasedCountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class MysticFeatures {

    public static class Placed {
        public static final DeferredRegister<PlacedFeature> PLACED_FEATURES = DeferredRegister.create((ResourceKey)Registry.f_194567_, (String)"mysticsbiomes");
        public static final RegistryObject<PlacedFeature> TREE_STRAWBERRY = PLACED_FEATURES.register("tree_strawberry", () -> new PlacedFeature(Holder.m_205706_((Holder)((Holder)Configured.STRAWBERRY_TREE.getHolder().orElseThrow())), VegetationPlacements.m_195481_((PlacementModifier)RarityFilter.m_191900_((int)3), (Block)Blocks.f_50746_)));
        public static final RegistryObject<PlacedFeature> TREE_PINK_CHERRY = PLACED_FEATURES.register("tree_pink_cherry", () -> new PlacedFeature(Holder.m_205706_((Holder)((Holder)Configured.PINK_CHERRY_TREE.getHolder().orElseThrow())), VegetationPlacements.m_195481_((PlacementModifier)NoiseBasedCountPlacement.m_191731_((int)4, (double)0.4, (double)1.0), (Block)Blocks.f_50746_)));
        public static final RegistryObject<PlacedFeature> TREE_WHITE_CHERRY = PLACED_FEATURES.register("tree_white_cherry", () -> new PlacedFeature(Holder.m_205706_((Holder)((Holder)Configured.WHITE_CHERRY_TREE.getHolder().orElseThrow())), VegetationPlacements.m_195481_((PlacementModifier)NoiseBasedCountPlacement.m_191731_((int)4, (double)0.4, (double)1.0), (Block)Blocks.f_50746_)));
        public static final RegistryObject<PlacedFeature> TREE_JACARANDA = PLACED_FEATURES.register("tree_jacaranda", () -> new PlacedFeature(Holder.m_205706_((Holder)((Holder)Configured.JACARANDA_TREE.getHolder().orElseThrow())), VegetationPlacements.m_195481_((PlacementModifier)RarityFilter.m_191900_((int)3), (Block)Blocks.f_50746_)));
        public static final RegistryObject<PlacedFeature> BUSH_PEONY = PLACED_FEATURES.register("bush_peony", () -> new PlacedFeature(Holder.m_205706_((Holder)((Holder)Configured.PEONY_BUSH.getHolder().orElseThrow())), VegetationPlacements.m_195481_((PlacementModifier)NoiseBasedCountPlacement.m_191731_((int)9, (double)0.4, (double)1.0), (Block)Blocks.f_50746_)));
        public static final RegistryObject<PlacedFeature> PATCH_LIGHT_GRASS = PLACED_FEATURES.register("patch_light_grass", () -> new PlacedFeature(Holder.m_205706_((Holder)((Holder)Configured.LIGHT_GRASS.getHolder().orElseThrow())), VegetationPlacements.m_195474_((int)12)));
        public static final RegistryObject<PlacedFeature> PATCH_STRAWBERRY_BUSH = PLACED_FEATURES.register("patch_strawberry_bush", () -> new PlacedFeature(Holder.m_205706_((Holder)((Holder)Configured.STRAWBERRY_BUSH.getHolder().orElseThrow())), List.of(RarityFilter.m_191900_((int)1), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_())));
        public static final RegistryObject<PlacedFeature> FLOWER_PINK_TULIP = PLACED_FEATURES.register("flower_pink_tulip", () -> new PlacedFeature(Holder.m_205706_((Holder)((Holder)Configured.PINK_TULIP.getHolder().orElseThrow())), List.of(RarityFilter.m_191900_((int)1), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_())));
        public static final RegistryObject<PlacedFeature> FLOWER_WHITE_TULIP = PLACED_FEATURES.register("flower_white_tulip", () -> new PlacedFeature(Holder.m_205706_((Holder)((Holder)Configured.WHITE_TULIP.getHolder().orElseThrow())), List.of(RarityFilter.m_191900_((int)1), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_())));
        public static final RegistryObject<PlacedFeature> FLOWER_LILAC = PLACED_FEATURES.register("flower_lilac", () -> new PlacedFeature(Holder.m_205706_((Holder)((Holder)Configured.LILAC.getHolder().orElseThrow())), List.of(RarityFilter.m_191900_((int)2), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_())));
        public static final RegistryObject<PlacedFeature> FLOWER_LAVENDER = PLACED_FEATURES.register("flower_lavender", () -> new PlacedFeature(Holder.m_205706_((Holder)((Holder)Configured.LAVENDER.getHolder().orElseThrow())), VegetationPlacements.m_195474_((int)48)));
    }

    public static class Configured {
        public static final DeferredRegister<ConfiguredFeature<?, ?>> CONFIGURED_FEATURES = DeferredRegister.create((ResourceKey)Registry.f_122881_, (String)"mysticsbiomes");
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> STRAWBERRY_TREE = Configured.register("strawberry_tree", Feature.f_65760_, () -> Configured.createBushyFoliage((Block)MysticBlocks.STRAWBERRY_LOG.get(), (Block)MysticBlocks.STRAWBERRY_BLOSSOMS.get(), 8, 0, 82).m_68251_());
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> PINK_CHERRY_TREE = Configured.register("pink_cherry_tree", Feature.f_65760_, () -> Configured.createBushyFoliage((Block)MysticBlocks.CHERRY_LOG.get(), (Block)MysticBlocks.PINK_CHERRY_BLOSSOMS.get(), 12, 6, 164).m_68251_());
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> WHITE_CHERRY_TREE = Configured.register("white_cherry_tree", Feature.f_65760_, () -> Configured.createBushyFoliage((Block)MysticBlocks.CHERRY_LOG.get(), (Block)MysticBlocks.WHITE_CHERRY_BLOSSOMS.get(), 12, 6, 164).m_68251_());
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> JACARANDA_TREE = Configured.register("jacaranda_tree", Feature.f_65760_, () -> new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)MysticBlocks.JACARANDA_LOG.get())), (TrunkPlacer)new BendingTrunkPlacer(4, 2, 0, 2, (IntProvider)UniformInt.m_146622_((int)1, (int)1)), (BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((Block)MysticBlocks.JACARANDA_BLOSSOMS.get()).m_49966_(), 3).m_146271_((Object)((Block)MysticBlocks.JACARANDA_LEAVES.get()).m_49966_(), 2)), (FoliagePlacer)new RandomSpreadFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)3), (IntProvider)ConstantInt.m_146483_((int)0), (IntProvider)ConstantInt.m_146483_((int)3), 82), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).m_68251_());
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> PEONY_BUSH = Configured.register("peony_bush", Feature.f_65760_, () -> new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_49999_), (TrunkPlacer)new StraightTrunkPlacer(1, 0, 0), (BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((Block)MysticBlocks.BUDDING_PEONY_LEAVES.get()).m_49966_(), 3).m_146271_((Object)((Block)MysticBlocks.PEONY_LEAVES.get()).m_49966_(), 3)), (FoliagePlacer)new BushFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)0), 2), (FeatureSize)new TwoLayersFeatureSize(0, 0, 0)).m_68251_());
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> LIGHT_GRASS = Configured.register("light_grass", Feature.f_65763_, () -> FeatureUtils.m_206476_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50034_)), List.of(Blocks.f_50440_)));
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> STRAWBERRY_BUSH = Configured.register("strawberry_bush", Feature.f_65763_, () -> Configured.createSimpleRandomPatch(400, 9, 2, (Holder<PlacedFeature>)PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((BlockState)((Block)MysticBlocks.STRAWBERRY_BUSH.get()).m_49966_().m_61124_((Property)StrawberryBushBlock.AGE, (Comparable)Integer.valueOf(5))))))));
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> PINK_TULIP = Configured.register("pink_tulip", Feature.f_65763_, () -> Configured.createSimpleRandomPatch(64, 7, 2, (Holder<PlacedFeature>)PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50119_)))));
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> WHITE_TULIP = Configured.register("white_tulip", Feature.f_65763_, () -> Configured.createSimpleRandomPatch(64, 7, 2, (Holder<PlacedFeature>)PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50118_)))));
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> LILAC = Configured.register("lilac", Feature.f_65763_, () -> Configured.createSimpleRandomPatch(64, 7, 2, (Holder<PlacedFeature>)PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50356_)))));
        public static final RegistryObject<ConfiguredFeature<RandomPatchConfiguration, ?>> LAVENDER = Configured.register("lavender", Feature.f_65763_, () -> new RandomPatchConfiguration(128, 9, 7, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)MysticBlocks.LAVENDER.get()))))));

        private static TreeConfiguration.TreeConfigurationBuilder createBushyFoliage(Block log, Block leaves, int baseHeight, int heightRandomA, int foliageAttempts) {
            return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)log), (TrunkPlacer)new FancyTrunkPlacer(baseHeight, heightRandomA, 0), (BlockStateProvider)BlockStateProvider.m_191382_((Block)leaves), (FoliagePlacer)new RandomSpreadFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)3), (IntProvider)ConstantInt.m_146483_((int)0), (IntProvider)ConstantInt.m_146483_((int)3), foliageAttempts), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1));
        }

        private static RandomPatchConfiguration createSimpleRandomPatch(int tries, int xzSpread, int ySpread, Holder<PlacedFeature> placement) {
            return new RandomPatchConfiguration(tries, xzSpread, ySpread, placement);
        }

        public static <FC extends FeatureConfiguration, F extends Feature<FC>> RegistryObject<ConfiguredFeature<FC, ?>> register(String name, F feature, Supplier<FC> configSupplier) {
            return CONFIGURED_FEATURES.register(name, () -> new ConfiguredFeature(feature, (FeatureConfiguration)configSupplier.get()));
        }
    }
}

